<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Creates OverView Tree hierarchy for all packages -->
	<xsl:template name="PackageTree">
		<xsl:param name="package"></xsl:param>
		
		<html>
		<head>
			<xsl:call-template name="ImportCSS"/>
		<title>
		<xsl:value-of select="$title_param"></xsl:value-of>
		</title>
		<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
		<xsl:call-template name="ImgLoaderScript"/>
		</head>

		<xsl:if test="$navbar_param">
			<xsl:call-template name="PackageTreeNavBar">
				<xsl:with-param name="header" select="'true'"></xsl:with-param>
				<xsl:with-param name="package" select="$package"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<hr/>
		
		<!-- Calculate relative path prefix -->
		<!--xsl:variable name="packagePath">
			<xsl:call-template name="pathResolver">
				<xsl:with-param name="element" select="$package"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable-->
		<!--xsl:variable name="relative" select="substring-after(string($packagePath), $outdir)"></xsl:variable-->
		<xsl:variable name="relativePrefix">
			<!--xsl:call-template name="RelativePrefix">
				<xsl:with-param name="path" select="substring-after($relative, '/')"></xsl:with-param>
				<xsl:with-param name="prefix" select="''"></xsl:with-param>
			</xsl:call-template-->
			<xsl:call-template name="GetCurrentPrefix"/>
		</xsl:variable>		
		
		<center>
		<h2>
		<xsl:choose>
			<xsl:when test="local-name($package)='Model'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'hierarchy_for_global_namespace_elements'"></xsl:with-param>
					<xsl:with-param name="p1" select="$package/@name"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'hierarchy_for_package'"></xsl:with-param>
				</xsl:call-template>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$package/@name"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
		</h2>
		</center>
		
			<dl>
			<dt>
			<b>
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'package_hierarchies'"></xsl:with-param>
			</xsl:call-template>
			</b>
			<dd>
				<xsl:variable name="packPath">
					<xsl:call-template name="treePathResolver">
						<xsl:with-param name="element" select="current()"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>			

				<xsl:variable name="overview" select="concat($relativePrefix, 'overview-tree.html')"></xsl:variable>
				<a href="{$overview}">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'all_packages'"></xsl:with-param>
				</xsl:call-template>
				</a>	
				
			</dd>
			</dt>
			</dl>
		<hr/>

		<!-- Class hierarchy -->
		<!--xsl:variable name="classes" select="$package/child::Classifier[@type='Class' or @type='Struct'][not(Extends)]"></xsl:variable-->
		<xsl:variable name="classes" select="$package/child::Classifier[@type='Class' or @type='Struct'][count(Extends)=count(Extends/@doom)]"></xsl:variable>
		<xsl:if test="$classes">
			<h2>
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'class_hierarchy'"></xsl:with-param>
			</xsl:call-template>
			</h2>
			<xsl:call-template name="PackageClassTree">
				<xsl:with-param name="package" select="$package"></xsl:with-param>
				<xsl:with-param name="classes" select="$classes"></xsl:with-param>
				<!--xsl:with-param name="sublevelClasses" select="$package/child::Classifier[@type='Class' or @type='Struct'][Extends]"></xsl:with-param-->
				<xsl:with-param name="sublevelClasses" select="$package/child::Classifier[@type='Class' or @type='Struct'][not(count(Extends)=count(Extends/@doom))]"></xsl:with-param>
			</xsl:call-template>
			<p/>
		</xsl:if>

		<!-- Interface hierarchy -->
		<!--xsl:variable name="interfaces" select="$package/child::Classifier[@type='Interface'][not(Extends)]"></xsl:variable-->
		<xsl:variable name="interfaces" select="$package/child::Classifier[@type='Interface'][count(Extends)=count(Extends/@doom)]"></xsl:variable>
		<xsl:if test="$interfaces">
			<h2>
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'interface_hierarchy'"></xsl:with-param>
			</xsl:call-template>
			</h2>
			<xsl:call-template name="PackageInterfaceTree">
				<xsl:with-param name="package" select="$package"></xsl:with-param>
				<xsl:with-param name="interfaces" select="$interfaces"></xsl:with-param>
				<!--xsl:with-param name="sublevelInterfaces" select="$package/child::Classifier[@type='Interface'][Extends]"></xsl:with-param-->
				<xsl:with-param name="sublevelInterfaces" select="$package/child::Classifier[@type='Interface'][not(count(Extends)=count(Extends/@doom))]"></xsl:with-param>
			</xsl:call-template>
			<p/>
		</xsl:if>

		<hr/>
		<xsl:if test="$navbar_param">
			<xsl:call-template name="PackageTreeNavBar">
				<xsl:with-param name="package" select="$package"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<br/>
		<p/>
		<xsl:value-of select="$bottom_param"></xsl:value-of>
		</html>
		
	</xsl:template>

</xsl:stylesheet>
